package gov.va.vinci.dart.biz;

import java.util.Comparator;
import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestDocumentTemplate extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		try {
			DocumentTemplate.findById(-1);
			Assert.fail("Expected ObjectNotFoundException");
		}
		catch (ObjectNotFoundException e) {}
		
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);
	}

	@Test
	public void testTwo() throws Exception {
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);
		Assert.assertTrue(dt.getSortOrder() > 0);
		
		DocumentTemplate dt2 = DocumentTemplate.findById(dt.getId());
		Assert.assertNotNull(dt2);
		Assert.assertEquals(dt2.getId(), dt.getId());
	}

	@Test
	public void testThree() throws Exception {
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate testDT = null;
		
		for (DocumentTemplate dt : dtList) {
			if (dt.isAdministrator() == true) {
				testDT = dt;
				break;
			}
		}
		
		Assert.assertNotNull(testDT);
		Assert.assertTrue(testDT.getId() > 0);
		Assert.assertTrue(testDT.isAdministrator());

		for (DocumentTemplate dt : dtList) {
			if (dt.isParticipant() == true) {
				testDT = dt;
				break;
			}
		}

		Assert.assertNotNull(testDT);
		Assert.assertTrue(testDT.getId() > 0);
		Assert.assertTrue(testDT.isParticipant());
		
		for (DocumentTemplate dt : dtList) {
			if (dt.isLocation() == true) {
				testDT = dt;
				break;
			}
		}

		Assert.assertNotNull(testDT);
		Assert.assertTrue(testDT.getId() > 0);
		Assert.assertTrue(testDT.isLocation());
		
		for (DocumentTemplate dt : dtList) {
			if (dt.getActivityType() != null) {
				testDT = dt;
				break;
			}
		}

		Assert.assertNotNull(testDT);
		Assert.assertTrue(testDT.getId() > 0);
		Assert.assertNotNull(testDT.getActivityType());
		Assert.assertTrue(testDT.getActivityType().length() > 0);

	}

	@Test
	public void testFour() throws Exception {
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 1);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);
		Assert.assertTrue(dt.getSortOrder() > 0);
		
		DocumentTemplate dt2 = dtList.get(1);
		Assert.assertNotNull(dt2);
		Assert.assertNotEquals(dt2.getId(), dt.getId());
		
		Assert.assertTrue(dt.getSortOrder() < dt2.getSortOrder());
		
		Comparator comp = DocumentTemplate.getComparator();
		Assert.assertNotNull(comp);
		Assert.assertEquals(comp.compare(dt, null), -1);
		Assert.assertEquals(comp.compare(null, dt), 1);
		Assert.assertEquals(comp.compare(null, null), 0);
		Assert.assertEquals(comp.compare(dt, ""), 0);
		Assert.assertEquals(comp.compare("", dt), 0);
		Assert.assertEquals(comp.compare(dt, dt), 0);
		Assert.assertEquals(comp.compare(dt, dt), 0);
		Assert.assertEquals(comp.compare(dt, dt2), -1);
		Assert.assertEquals(comp.compare(dt2, dt), 1);
	}

}
